<?php declare(strict_types=1);
/**
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade the Frakmenta plugin
 * to newer versions in the future. If you wish to customize the plugin for your
 * needs please document your changes and make backups before you update.
 *
 * @category    Frakmenta
 * @package     Connect
 * @author      Findirect <desarrollo-frakmenta@findirect.com>
 * @copyright   Copyright (c) Frakmenta, Findirect. (https://www.frakmenta.com)
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 * Plugin Name:             Frakmenta
 * Plugin URI:              https://frakmenta.com/desarrolladores
 * Description:             Frakmenta Payment Plugin - Compatible con WooCommerce HPOS
 * Version:                 3.1.0
 * Author:                  Findirect
 * Author URI:              https://www.frakmenta.com
 * Copyright:               Copyright (c) Frakmenta, Findirect. (https://www.frakmenta.com)
 * License:                 GNU General Public License v3.0
 * License URI:             http://www.gnu.org/licenses/gpl-3.0.html
 * Requires at least:       6.0
 * Tested up to:            6.7
 * WC requires at least:    8.0.0
 * WC tested up to:         9.4.0
 * Requires PHP:            8.0
 * Text Domain:             frakmenta
 * Domain Path:             /languages
 */

if (!defined('ABSPATH')) {
    die();
}

/**
 * Plugin version
 */
define('FRAKMENTA_PLUGIN_VERSION', '3.1.0');

/**
 * Simulate confirmation in test mode (for development/testing)
 * Set to true to simulate successful payment confirmations when in test mode
 * Set to false to use real API verification
 */
define('FRAKMENTA_CONFIRMATION_SIMULATE', false);

/**
 * Plugin URL
 * Do not include a trailing slash. Should be include it in the string with which is concatenated
 */
define('FRAKMENTA_PLUGIN_URL', plugins_url('', __FILE__));

/**
 * Plugin dir path
 * Include a trailing slash. Should not be include it in the string with which is concatenated
 */
define('FRAKMENTA_PLUGIN_DIR_PATH', plugin_dir_path(__FILE__));

/**
 * Composer's autoload file.
 */
require_once FRAKMENTA_PLUGIN_DIR_PATH . 'vendor/autoload.php';

use Frakmenta\WooCommerce\Utils\Activator;
use Frakmenta\WooCommerce\Main;

/**
 * The code that runs during plugin activation.
 * The class is documented in src/utils/Activator.php
 *
 * @param bool $network_wide
 * @see     https://developer.wordpress.org/reference/functions/register_activation_hook/
 *
 * @since   4.0.0
 */
function activate_frakmenta(bool $network_wide): void
{
    $activator = new Activator();
    $activator->activate($network_wide);
}

register_activation_hook(__FILE__, 'activate_frakmenta');

/**
 * Declare HPOS compatibility
 *
 * @since    2.0.0
 */
add_action('before_woocommerce_init', function() {
    if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
    }
});

/**
 * Init plugin
 *
 * @since    4.0.0
 * @see      https://developer.wordpress.org/plugins/hooks/
 */
function init_frakmenta(): void
{
    if (!function_exists('is_plugin_active')) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
      
    if (is_plugin_active('woocommerce/woocommerce.php')) {
        error_log('WooCommerce está activo - Inicializando Frakmenta');
        $plugin = new Main();
        $plugin->init();
        error_log('Main() instanciado e init() ejecutado');
    } else {
        error_log('WooCommerce NO está activo - Frakmenta no se cargará');
    }
}

add_action('plugins_loaded', 'init_frakmenta');


