/**
 * Frakmenta Checkout Handler - Intercepts payment process to show modal
 */
(function($) {
    'use strict';

    console.log('Frakmenta Checkout Handler cargado');

    const FrakmentaCheckout = {
        init: function() {
            console.log('Inicializando interceptor de checkout');
            
            // For classic checkout
            if ($('form.checkout').length) {
                this.bindClassicCheckout();
            }
            
            // For block checkout - will be handled differently
            this.observeBlockCheckout();
        },

        bindClassicCheckout: function() {
            console.log('Vinculando checkout clásico');
            
            $(document.body).on('checkout_place_order_success', (event, result) => {
                console.log('Checkout place order success:', result);
                
                // Check if payment method is frakmenta
                const paymentMethod = $('input[name="payment_method"]:checked').val();
                console.log('Método de pago seleccionado:', paymentMethod);
                
                if (paymentMethod === 'frakmenta' && result.redirect) {
                    console.log('Interceptando redirect de Frakmenta');
                    console.log('URL de pago:', result.redirect);
                    
                    // Prevent default redirect
                    event.preventDefault();
                    
                    // Open modal instead
                    if (window.FrakmentaModal) {
                        window.FrakmentaModal.open(result.redirect);
                    } else {
                        console.error('FrakmentaModal no disponible, usando redirect normal');
                        window.location.href = result.redirect;
                    }
                    
                    return false;
                }
                
                return true;
            });
            
            console.log('Checkout clásico vinculado');
        },

        observeBlockCheckout: function() {
            console.log('Observando checkout de bloques');
            
            // For blocks, we need to intercept differently
            // Listen for the wc-blocks checkout response
            document.addEventListener('wc-blocks_checkout_process_with_success', (event) => {
                console.log('Blocks checkout success:', event);
                
                // This will be handled by the blocks integration
                // We'll add specific handling in frakmenta-blocks.js
            });
        }
    };

    // Initialize on document ready
    $(document).ready(function() {
        FrakmentaCheckout.init();
        console.log('FrakmentaCheckout inicializado');
    });

    // Also try to initialize on window load (for blocks)
    $(window).on('load', function() {
        // Double check initialization for blocks
        setTimeout(() => {
            if ($('.wc-block-checkout').length && !FrakmentaCheckout.initialized) {
                console.log('Re-inicializando para checkout de bloques');
                FrakmentaCheckout.init();
                FrakmentaCheckout.initialized = true;
            }
        }, 500);
    });

})(jQuery);
