# Changelog
## [3.1.0] - 2025-11-28

### Añadido
- Compatibilidad completa con WooCommerce 9.x
- Declaración de compatibilidad con HPOS (High-Performance Order Storage)
- Soporte para PHP 8.0, 8.1, 8.2 y 8.3
- Type hints estrictos en todos los métodos
- Validación y sanitización de todos los inputs POST
- Manejo de excepciones mejorado
- Métodos privados para mejor encapsulación
- Documentación PHPDoc completa

### Cambiado
- **BREAKING**: Requisito mínimo de PHP aumentado a 8.0
- **BREAKING**: Requisito mínimo de WooCommerce aumentado a 8.0
- Refactorización completa de `OrderService` con separación de responsabilidades
- Refactorización de `BasePaymentMethod` con métodos privados
- Refactorización de `FrakmentaPayment` con mejor manejo de errores
- Refactorización de `PaymentMethodsController` con métodos separados
- Uso de `WC()->cart` en lugar de `global $woocommerce`
- Inicialización del plugin movida al hook `plugins_loaded`

### Seguridad
- Sanitización de `$_POST['validate_payfrakmenta']` con `sanitize_text_field()`
- Uso de `wp_unslash()` para prevenir problemas de escape
- Validación de existencia de objetos antes de usarlos
- Mejor manejo de errores de API

### Eliminado
- Llamadas a `error_log()` en código de producción
- Código comentado innecesario
- Líneas en blanco excesivas
- Duplicación de código en constructor
- Uso de `$order->reduce_order_stock()` (deprecado)
- Uso de `wc_get_endpoint_url()` para URLs de órdenes

### Corregido
- Uso de método deprecado `reduce_order_stock()` reemplazado por `wc_reduce_stock_levels()`
- Uso de `get_the_id()` (incorrecto) reemplazado por `get_the_ID()`
- Comparaciones con `==` reemplazadas por `===` para mayor seguridad
- Validación de respuestas de API antes de acceder a propiedades

### Compatibilidad con HPOS
- Uso de `wc_reduce_stock_levels($order_id)` en lugar de `$order->reduce_order_stock()`
- Uso de `$order->get_checkout_order_received_url()` en lugar de construcción manual de URL
- Todos los métodos usan las APIs modernas de WooCommerce
- Declaración explícita de compatibilidad con `custom_order_tables`

### Arquitectura
- Separación de métodos largos en métodos más pequeños
- Extracción de lógica de `create_order_frakmenta` en 8 métodos privados:
  - `buildCartProducts()`
  - `buildCustomerData()`
  - `buildOrderData()`
  - `buildFlowConfig()`
  - `generateInvoiceId()`
  - `calculateProductPrice()`
  - `buildOperationData()`
  - `generateSignature()`
- Extracción de lógica de `getStatusOperationFrakmenta` en método privado:
  - `generateStatusSignature()`
- Extracción de métodos en `PaymentMethodsController`:
  - `enqueueProductScripts()`
  - `enqueueCheckoutScripts()`
- Extracción de método en `BasePaymentMethod`:
  - `updateCheckoutTitle()`

### Composer
- Actualización de `composer.json` con metadatos correctos
- Cambio de namespace correcto: `Frakmenta\WooCommerce\`
- Añadidas dependencias de desarrollo: PHPStan y PHP_CodeSniffer
- Configuración de optimización de autoloader
- Cambio de estabilidad mínima a `stable`

**Cambios IMPORTANTES:**
- El plugin requiere WordPress a 6.0+, WooCommerce a 8.0+
- El plugin ahora requiere PHP 8.0 como mínimo
- Compatible con HPOS (High-Performance Order Storage)
- Los métodos deprecados han sido reemplazados
- Mejor seguridad y validación de datos