{*
* 2021 Sistemas findirect
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Jose Baez
*  @author 2021
*  @author <desarrollo@frakmenta.com>
*  @copyright Sistemas findirect
*
*  @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
*
*}
<div class="bootstrap">
	<div class="alert alert-danger error-config-frakmenta" style="display:none">
		Debes indicar un modo de conexión para frakmenta
	</div>
</div>


<div class="bootstrap">

	{if isset($frakmenta_save_sucess) && $frakmenta_save_sucess}
		<div class="alert alert-info ps-checkout-info">
			<button type="button" class="close" data-dismiss="alert" data-action="close">×</button>
			Se ha actualizado correctamente la configuración
		</div>

		{if $Frakmenta_mode == 0}
		<div class="alert alert-warning ps-checkout-info">
			<button type="button" class="close" data-dismiss="alert" data-action="close">×</button>
			Su conexión ahora se encuentra en modo de pruebas
		</div>
		{elseif  $Frakmenta_mode == 1}
		<div class="alert alert-success ps-checkout-info">
			<button type="button" class="close" data-dismiss="alert" data-action="close">×</button>
			Su conexión ahora se encuentra en modo de producción
		{/if}
	{/if}
</div>

<div id="frakmenta-wrapper">
	<div id="general" frakmenta-tab-content>
		{* Header de configuración de frakmenta *}
		<div class="box half left">
			<img src="{$moduleDir|addslashes}/frakmenta-logo-original.png" alt="" style="margin-bottom: -5px; max-height: 80px;" />
			<p>Frakmenta es una solución de financiación adaptada a las necesidades de los clientes</p>
		</div>

		<div class="box half right">
			<ul class="tick">
				<li><span class="frakmenta-bold">Facilita el pago a tus clientes</span></li>
				<li><span class="frakmenta-bold">Ofrece una solución adaptada a sus necesidades de pago</li>
				<li>
					<span class="frakmenta-bold">Incrementa tus ventas, tu ticket medio y mejora la experiencia</span>
					<br>
					<span class="frakmenta-bold">de compra de tus clientes</span>				
				</li>
				<li><span class="frakmenta-bold">Que la forma de pago sea un beneficio para tu negocio</span></li>
			</ul>
		</div>

		<div class="frakmenta-clear"></div>


		{if $language_store}
		<div class="frakmenta-clear"></div><hr>
		<input type="hidden" id="fk_exists" value="{$Frakmenta_account}">
		
		

		<form method="post" action="{$smarty.server.REQUEST_URI|escape:'htmlall':'UTF-8'}" id="frakmenta_configuration">
		<input type="hidden" name="fk_mode" id="fk_mode" value="{$Frakmenta_mode}"/>

			{* Frakmenta configuration *}
			<div class="box">
				<h3 class="inline">{l s='Configurar frakmenta es muy sencillo' mod='frakmenta'}</h3>
				<div style="line-height: 20px; margin-top: 8px">
					<div>
						<label>Tu país es: <strong>{$currentCountry|escape:'htmlall':'UTF-8'}</strong> ({$currentCountryIso|escape:'htmlall':'UTF-8'})</label>
					</div>

					<label>¿Tienes una cuenta de frakmenta?</label>&nbsp;&nbsp;
					<input type="radio" name="fk_account" id="frakmenta_business_account_no" onclick="frakmentaAccount(0)" value="0" {if $Frakmenta_account == 0}checked="checked"{/if} /> <label for="frakmenta_business_account_no">No</label>
					<input type="radio" name="fk_account" id="frakmenta_business_account_yes" onclick="frakmentaAccount(1)" value="1" style="margin-left: 14px" {if $Frakmenta_account == 1}checked="checked"{/if} /> <label for="frakmenta_business_account_yes">Si</label>
				</div>
			</div>

			<div class="frakmenta-clear"></div><hr />

			{* Registro en frakmenta *}
			<div id="fk_register">
			<br/><br/>
				<div data-open-account-section id="account">
					<h3 class="inline">Como empezar a trabajar con frakmenta</h3>
					<br/><br/>
<ul>
	<li>Para que funcione el plugin, tendrás que crear tu cuenta con frakmenta. Puedes hacerlo <a target="_blank" href="https://static.frakmenta.com/oferta-comercial">aquí</a></li>
	<li>Desde frakmenta nos pondremos en contacto contigo para homologar tu comercio. También puedes llamarnos al 91 258 29 29 o escribirnos en infoclientes@frakmenta.com</li>
	<li>Puedes activar el modo prueba para verificar el funcionamiento del módulo</li>
	<li>Activa el módulo en modo producción ten en encuenta que vas a necesitar:</li>
	<li>Introducir el código e-commerce que te ha asignado frakmenta</li>
	<li>Introducir la Clave pública de acceso a frakmenta</li>
	<li>Introducir la Clave privada de acceso a frakmenta</li>
</ul>
<br/>

<p>¿Necesitas ayuda?</p>
<p>No dudes en contactar a nuestro servicio de atención al cliente:</p>
<p>91 258 29 29</p>
<p>infoclientes@frakmenta.com</p>
<p>frakmenta.com/contacto-web</p>

				</div>
			</div>

			<div data-configuration-section class="box " id="credentials">

				<div class="right half" id="frakmenta-call-button">
					<div id="frakmenta-call" class="box right"><span style="font-weight: bold">¿Necesitas ayuda?</span> <a target="_blank" href="https://frakmenta.com/contacto-web">Contáctanos</a></div>
				</div>

				<h3 class="inline">Configura tu conexión con frakmenta</h3>
				<br /><br />

				<div class="frakmenta-hide" id="configuration">
					{* Credentials *}

					<h4>Indica a continuación tu información de conexión con frakmenta a Prestashop</h4>

					<div id="fk-mode">
						<p><span class="frakmenta-bold">Modo de conexión hacia frakmenta<br/><br/></span></p>
						<button type="button" class="btn-mode mini ui button test_fk {if $Frakmenta_mode == '0'} teal {/if}" onclick="frakmenta_mode(0)">Pruebas</button>
						<button type="button" class="btn-mode mini ui button prod_fk {if $Frakmenta_mode == '1'} teal {/if}" onclick="frakmenta_mode(1)">Producción</button>
					</div>
					<div id="standard-credentials" {if $Frakmenta_mode == '0'} style="display: none" {/if}>
						<dl>
							<dt><label for="api_signature">Código e-commerce</label></dt>
							<dd><input type='text' size="10" name="fk_merchant_id" id="fk_merchant_id" value="{if $Frakmenta_mode == '1'} {$Frakmenta_merchant_id|escape:'html':'UTF-8'} {/if}" autocomplete="off" required /></dd>
							<dt><label for="api_username">Llave pública</label></dt>
							<dd><input type='text' name="fk_public_key" id="fk_public_key" value="{if $Frakmenta_mode == '1'} {$Frakmenta_public_key|escape:'html':'UTF-8'} {/if}" autocomplete="off" size="85" required/></dd>
							<dt><label for="api_password">Llave privada</label></dt>
							<dd><input type='text' size="85" name="fk_private_key" id="fk_private_key" value="{if $Frakmenta_mode == '1'} {$Frakmenta_private_key|escape:'html':'UTF-8'} {/if}" autocomplete="off" required/></dd>
						</dl>
						<div class="frakmenta-clear"></div>
						<span class="description">Por favor verifica que la información proporcionada esté completa</span>
					</div>
					<div class="clear"></div>

				</div>
				<br /><br />
				<h3 class="inline">Opciones adicionales de frakmenta</h3><br/>
				<div class="col-lg-4">
				<strong>¿Deseas activar el simulador de frakmenta en los productos?</strong>
					<select name="fk_sim_product" style="width:100px">
						<option value="1" {if $Frakmenta_simulator_products == 1} selected {/if}>Si</option>
						<option value="0" {if $Frakmenta_simulator_products == 0} selected {/if}>No</option>
					</select>
				</div>
				<div class="col-lg-4">
					<strong>¿Donde quieres colocar el simulador de frakmenta?</strong>
					<select name="fk_location_simulator">
						<option value=".product-add-to-cart" {if $Frakmenta_location_simulator == ".product-add-to-cart"} selected {/if}>En la parte inferior del importe del producto</option>
						<option value=".social-sharing" {if $Frakmenta_location_simulator == ".social-sharing"} selected {/if}>En la parte inferior de las redes sociales</option>
					</select>
				</div>				
				<br /><br /><br />
				<br /><br />
				<input class="ui button text-uppercase btn-frakmenta" type="submit" name="submitButton" value="Guardar configuración" onclick="return validate_config_fk()" />
			</div>

			{* TEST FOR CURL*}
			<div id="fk-test-conn" style="display:none">
			<hr id="line-test"/>

				<div class="frakmenta-hide box-fk" data-tls-check-section id="test-fk">
					<h3 class="inline">Prueba tu conexión a frakmenta</h3>
					<br /><br />
					<span class="ui button sm btn-frakmenta" data-url="{$Frakmenta_endpoint}" data-token="{$Frakmenta_public_key}" style="cursor: pointer;display: inline-block;" id="test_fk_connection"><b>Probar conexión a frakmenta</b></span>
					<div style="margin-top: 10px;" id="test_fk_conection_result"></div>
				</div>
			</div>

		</form>

		{else}
		<div class="frakmenta-clear"></div><hr />
		<div class="box">
			<p>Tú pais no está habilitado para este módulo por favor ve a Prestashop para buscar más posibilidades</p>
		</div>
		<hr />
	</div>

	{/if}
	</div>


</div>