/*
    * 2021 Sistemas findirect
    *
    * NOTICE OF LICENSE
    *
    * This source file is subject to the Academic Free License (AFL 3.0)
    * that is bundled with this package in the file LICENSE.txt.
    * It is also available through the world-wide-web at this URL:
    * http://opensource.org/licenses/afl-3.0.php
    *
    * DISCLAIMER
    *
    * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
    * versions in the future. If you wish to customize PrestaShop for your
    * needs please refer to http://www.prestashop.com for more information.
    *
    *  @author Jose Baez
    *  @author 2021
    *  @author <desarrollo@frakmenta.com>
    *  @copyright Sistemas findirect
    *
    *  @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
*/

$(document).ready(function () {

    init();

    /* Display correct block according to different choices. */
    function displayConfiguration() {

        $('#standard-credentials').slideDown();

        // $('#standard-credentials').slideUp();
        return;
    }

    if ($('#frakmenta-wrapper').length != 0) {
        $('.hide').hide();
        displayConfiguration();
    }

    if ($('#fk_mode').val()==0)
        $('#standard-credentials').hide();

    $('#test_fk_connection').click(function() {
        let url = this.dataset.url + "/api/fk/v2/configuration/validation";

        let formData = new FormData();
        formData.append("merchant_id", frakmenta_merchant_id_validation);
        formData.append("delegation", "1");
        formData.append("public_key", frakmenta_public_key_validation);
        formData.append("signature", frakmenta_sign_validation);

        let xhr = new XMLHttpRequest();
        xhr.addEventListener("readystatechange", function(data, status) {
            if (this.readyState === XMLHttpRequest.DONE) {
                handleTestConnectionResponse(this);
            }
        });

        xhr.open("POST", url);
        xhr.responseType = 'json';
        xhr.send(formData);
    });
});

function init()
{    
    $account = $('#fk_exists').val();

    if ($account==0) {
        $('#credentials').slideUp();
        $('#test-fk').slideUp();
        $('#fk_register').slideDown();
        frakmenta_mode(0);
    }
    else {
        $('#fk_register').slideUp();
        $('#credentials').slideDown();
        $('#configuration').slideDown();
        $('#fk-test-conn').slideDown();
        $('#test-fk').slideDown();
        if (document.getElementById('fk_mode'))
            frakmenta_mode(document.getElementById('fk_mode').value);
    }

}

function frakmentaAccount(account)
{
    if (account==0)
    {
        $('#credentials').slideUp();
        $('#test-fk').slideUp();
        $('#fk-test-conn').slideUp();
        $('#configuration').slideUp();
        $('#fk_register').slideDown();
    }
    else 
    {
        $('#fk_register').slideUp();
        $('#credentials').slideDown();
        $('#configuration').slideDown();
        $('#fk-test-conn').slideDown();
        $('#test-fk').slideDown();
    }
    frakmenta_mode($('#fk_mode').val());
}

function frakmenta_mode(type) {
    if (type==0)
    {
        $('.prod_fk').removeClass('teal');
        $('.test_fk').addClass('teal');
        $('#standard-credentials').hide();
        $('#fk_private_key').removeAttr('required');
        $('#fk_public_key').removeAttr('required');
        $('#fk_merchant_id').removeAttr('required');
    }
    else
    {
        $('#fk_private_key').prop('required', true);
        $('#fk_public_key').prop('required', true);
        $('#fk_merchant_id').prop('required', true);
        $('.test_fk').removeClass('teal');
        $('.prod_fk').addClass('teal');
        $('#standard-credentials').show();
    }

    if (document.getElementById('fk_mode'))
        document.getElementById('fk_mode').value=type;
}

function validate_config_fk()
{
    $('.error-config-frakmenta').fadeOut();

    if ($('#fk_mode').val()=="-1") 
    {
        $('.error-config-frakmenta').fadeIn();
        return false;
    }
}

function handleTestConnectionResponse(testConnection) {
    let $fk_conn_result = $('#test_fk_conection_result');
    $fk_conn_result.removeClass('text-danger text-success');

    let resultMessage = 'Conexión exitosa';
    let resultClass = 'text-sucess';

    if (testConnection.status !== 200) {
        resultMessage = 'Conexión fallida';
        resultClass = 'text-danger';
    }

    $fk_conn_result.html(resultMessage);
    $fk_conn_result.addClass(resultClass);
}
