<?php
/**
 * 2021 Sistemas findirect
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 *
 * @author Jose Baez
 * @author <desarrollo@frakmenta.com>
 * @copyright Sistemas findirect
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

namespace Frakmenta\Exception;

use Exception;

/**
 * Class FrakmentaException
 * 
 * Excepción base para el módulo Frakmenta
 * Todas las excepciones específicas del módulo deben heredar de esta clase
 * 
 * @package Frakmenta\Exception
 */
class FrakmentaException extends Exception
{
    /**
     * Constructor de FrakmentaException
     *
     * @param string $message Mensaje de error
     * @param int $code Código de error (opcional)
     * @param Exception|null $previous Excepción anterior para encadenar (opcional)
     */
    public function __construct(string $message = '', int $code = 0, ?Exception $previous = null)
    {
        parent::__construct($message, $code, $previous);
    }
    
    /**
     * Representación en string de la excepción
     *
     * @return string
     */
    public function __toString(): string
    {
        return __CLASS__ . ": [{$this->code}]: {$this->message}\n";
    }
}
