<?php
/**
 * 2021 Sistemas findirect
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 *
 * @author Jose Baez
 * @author <desarrollo@frakmenta.com>
 * @copyright Sistemas findirect
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

namespace Frakmenta\Config;

/**
 * Class FrakmentaConstants
 * 
 * Contiene todas las constantes utilizadas en el módulo Frakmenta
 * Elimina los "magic numbers" y "magic strings" del código
 * 
 * @package Frakmenta\Config
 */
class FrakmentaConstants
{
    // Module information
    public const MODULE_NAME = 'frakmenta';
    public const MODULE_VERSION = '3.0.0';
    
    // URLs
    public const PRODUCTION_URL = 'https://frakmenta.com';
    public const TEST_URL = 'https://beta2.frakmenta.com';
    
    // Test credentials (no se deben usar en producción)
    public const TEST_PUBLIC_KEY = 'ae8dffe2183df23633746d6cd056e74ffa7b596a0337e9dacd1e876170757ca6';
    public const TEST_MERCHANT_ID = '27785';
    public const TEST_PRIVATE_KEY = '423d6f3a595b9c47eb0fb47dc786ae7cc52e35f178dc83463d851867b68ab5f9';
    
    // Mode configuration
    public const MODE_TEST = 0;
    public const MODE_PRODUCTION = 1;
    
    // Transaction states
    public const STATE_INITIALIZED = 'initialized';
    public const STATE_FAILED = 'failed';
    public const STATE_OK = 'ok';
    public const STATE_PENDING = 'pending';
    
    // HTTP codes
    public const HTTP_OK = 200;
    public const HTTP_CREATED = 201;
    public const HTTP_BAD_REQUEST = 400;
    public const HTTP_UNAUTHORIZED = 401;
    public const HTTP_NOT_FOUND = 404;
    public const HTTP_INTERNAL_ERROR = 500;
    
    // Default configuration
    public const DEFAULT_DELEGATION = '1';
    public const DEFAULT_CURRENCY = 'EUR';
    public const OPERATION_TYPE = 'e-commerce';
    public const DEFAULT_COUNTRY = 'ES';
    public const EXIST_ACCOUNT = 0;
    public const PRODUCT_OPTION = 0;
    public const LOCATION_SIMULATOR_DEFAULT = '.product_attributes';
    
    // Cart total types
    public const ONLY_PRODUCTS = 1;
    public const ONLY_DISCOUNTS = 2;
    public const BOTH = 3;
    public const BOTH_WITHOUT_SHIPPING = 4;
    public const ONLY_SHIPPING = 5;
    public const ONLY_WRAPPING = 6;
    public const ONLY_PRODUCTS_WITHOUT_SHIPPING = 7;
    
    // Database
    public const TABLE_NAME = 'frakmenta_petitions';
    
    // API endpoints
    public const ENDPOINT_OPERATIONS = '/api/fk/v2/operations';
    public const ENDPOINT_OPERATIONS_STATUS = '/api/fk/v2/operations/status';
    public const ENDPOINT_LIMITS = '/api/fk/v2/limits';
    public const ENDPOINT_CONFIG_VALIDATION = '/api/fk/v2/configuration/validation';
    
    // Timeout settings
    public const API_TIMEOUT = 30;
    public const API_MAX_REDIRECTS = 10;
    
    // Supported countries
    public const SUPPORTED_COUNTRIES = ['ES'];
    
    // PHP Requirements
    public const MIN_PHP_VERSION = '7.4';
    public const RECOMMENDED_PHP_VERSION = '8.1';
    
    /**
     * Obtiene la URL según el modo de operación
     *
     * @param int $mode Modo de operación (MODE_TEST o MODE_PRODUCTION)
     * @return string URL correspondiente
     */
    public static function getUrlByMode(int $mode): string
    {
        return $mode === self::MODE_PRODUCTION ? self::PRODUCTION_URL : self::TEST_URL;
    }
    
    /**
     * Verifica si un estado es válido
     *
     * @param string $state Estado a verificar
     * @return bool True si el estado es válido
     */
    public static function isValidState(string $state): bool
    {
        return in_array($state, [
            self::STATE_INITIALIZED,
            self::STATE_FAILED,
            self::STATE_OK,
            self::STATE_PENDING
        ], true);
    }
}
