<?php
/**
* 2021 Sistemas findirect
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Jose Baez
*  @author 2021
*  @author <desarrollo@frakmenta.com>
*  @copyright Sistemas findirect
*
*  @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
*
*/

if (!defined('_PS_VERSION_')) {
    exit;
}

class FrakmentaInstall
{
    /**
     * Create frakmenta tables
     */
    public function createTables()
    {
        /* Set database */
        if (!Db::getInstance()->Execute('
        CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'frakmenta_petitions` (
            `id_fk` bigint(20) NOT NULL AUTO_INCREMENT ,
            `id_cart` int(11) NOT NULL,
            `id_custom_client` varchar(200) NOT NULL,
            `id_operation` bigint(20) NOT NULL,
            `id_order` INT NULL, 
            `petition_state` varchar(100) NOT NULL DEFAULT "initialized",
            `attempts` int(11) NOT NULL,
            `state_detail` varchar(200) DEFAULT NULL,
            `id_invoice` varchar(100) NOT NULL,
            `ammount` bigint(20) NOT NULL,
            `create_date` timestamp NOT NULL DEFAULT current_timestamp(),
            `update_date` timestamp NULL DEFAULT NULL,
            PRIMARY KEY (`id_fk`), UNIQUE (`id_invoice`)
        ) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8')) {
            return false;
        }
    }

    /**
     * Set frakmenta configuration
     */
    public function updateConfiguration()
    {
        Configuration::updateValue('FRAKMENTA_ACCOUNT', Frakmenta::FRAKMENTA_EXIST_ACCOUNT);
        Configuration::updateValue('FRAKMENTA_URL', Frakmenta::FRAKMENTA_TEST_URL);
        Configuration::updateValue('FRAKMENTA_PUBLIC_KEY', Frakmenta::FRAKMENTA_TEST_PUBLIC_KEY);
        Configuration::updateValue('FRAKMENTA_PRIVATE_KEY', Frakmenta::FRAKMENTA_TEST_PRIVATE_KEY);
        Configuration::updateValue('FRAKMENTA_MERCHANT_ID', Frakmenta::FRAKMENTA_TEST_MERCHANT_ID);
        Configuration::updateValue('FRAKMENTA_DELEGATION', '1');
        Configuration::updateValue('PS_ALLOW_HTML_IFRAME', 1);
        Configuration::updateValue('FRAKMENTA_PRODUCT_OPTION', 0);
        Configuration::updateValue('FRAKMENTA_LOCATION_SIMULATOR', Frakmenta::LOCATION_SIMULATOR_DEFAULT);
    }

    /**
     * Delete frakmenta configuration
     */
    public function deleteConfiguration()
    {
        Configuration::deleteByName('FRAKMENTA_ACCOUNT');
        Configuration::deleteByName('FRAKMENTA_URL');
        Configuration::deleteByName('FRAKMENTA_PUBLIC_KEY');
        Configuration::deleteByName('FRAKMENTA_MERCHANT_ID');
        Configuration::deleteByName('FRAKMENTA_DELEGATION');
        Configuration::deleteByName('FRAKMENTA_PRIVATE_KEY');
    }

    public function moveTopPayments($position)
    {
        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            $hook_payment = (int) Hook::get('payment');
        } else {
            $hook_payment = (int) Hook::getIdByName('payment');
        }

        $module_instance = Module::getInstanceByName(Frakmenta::FRAKMENTA_MODULE_NAME);

        if (version_compare(_PS_VERSION_, '1.5', '<')) {
            $module_info = Hook::getModuleFromHook($hook_payment, $module_instance->id);
        } else {
            $module_info = Hook::getModulesFromHook($hook_payment, $module_instance->id);
        }

        if ((isset($module_info['position']) && (int) $module_info['position'] > (int) $position) ||
            (isset($module_info['m.position']) && (int) $module_info['m.position'] > (int) $position)) {
            return $module_instance->updatePosition($hook_payment, 0, (int) $position);
        }

        return $module_instance->updatePosition($hook_payment, 1, (int) $position);
    }
}
