<?php
/*
* 2021 Sistemas findirect
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author Jose Baez
*  @author 2021
*  @author <desarrollo@frakmenta.com>
*  @copyright Sistemas findirect
*
*  @license http://opensource.org/licenses/osl-3.0.php Open Software License (OSL 3.0)
*/

class FrakmentaSuccessModuleFrontController extends ModuleFrontController
{
    public $ssl = true;
    public $display_column_left = false;

    public function initContent()
    {
        if (!empty($_GET['id']))
        {
            $fk = new Frakmenta();
            $statusAPIResponseOperation = 0;

            $result = $fk->getDbFrakmentaTransactionDetailsByKeyCart($_GET['id'], $_GET['cart'], $_GET['invoice']);

            if (strtolower($result[0]['petition_state'])!='ok' && $result[0]['id_operation']!=-1){
                $statusAPIOperation = json_decode($fk->getStatusOperationFrakmenta($result[0]['id_operation']));

                if ($statusAPIOperation->messages[0]=='La operación ha sido aceptada'){

                    $updateTrans = $fk->getDbFrakmentaTransactionDetailsByInvoiceId($statusAPIOperation->data->invoice_id);

                    if ($updateTrans)
                        $order_id = (int)$fk->frakmentaManagerTransaction($updateTrans, $statusAPIOperation->status);

                    if (!empty($order_id)) {
                        $fk->updateDbFrakmentaTransactionDetails($statusAPIOperation->data->invoice_id, $statusAPIOperation->status, $statusAPIOperation->messages[0], $order_id);
                        $statusAPIResponseOperation=1;

                        $result = $fk->getDbFrakmentaTransactionDetailsByKeyCart($_GET['id'], $_GET['cart'], $_GET['invoice']);

                    }
                }
            }

            if (strtolower($result[0]['petition_state'])=='ok' || $statusAPIResponseOperation==1)
            {
                $module = Module::getInstanceByName(FRAKMENTA::FRAKMENTA_MODULE_NAME);
                Tools::redirect('index.php?controller=order-confirmation&id_cart='.$result[0]['id_cart'].'&id_module='.$module->id.'&id_order='.$result[0]['id_order'].'&key='.$result[0]['id_custom_client'].'&invoice='.$_GET['invoice']);
            }
            elseif ($result && strtolower($result[0]['petition_state'])!='ok')
            {
                $attempt = $fk->updateAttemptgetStatusTransactionFk($_GET['id'], $_GET['cart'], $_GET['invoice']);

                $this->context->smarty->assign(array(
                    'attempt' => (int) $attempt[0]['attempts'],
                ));

                parent::initContent();
                $this->setTemplate('module:frakmenta/views/templates/front/awaiting.tpl');
            }
            else
            {
                parent::initContent();
                $this->setTemplate('module:frakmenta/views/templates/front/unknow.tpl');
            }
        }
    }
}