<?php
/**
 * 2021 Sistemas findirect
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 *
 * @author Jose Baez
 * @author <desarrollo@frakmenta.com>
 * @copyright Sistemas findirect
 * @license http://opensource.org/licenses/afl-3.0.php Academic Free License (AFL 3.0)
 */

/**
 * Autoloader para las clases del módulo Frakmenta
 * Carga automáticamente las clases del namespace Frakmenta
 */
spl_autoload_register(function ($class) {
    // Prefijo del namespace
    $prefix = 'Frakmenta\\';
    
    // Directorio base para el namespace
    $baseDir = __DIR__ . '/src/';
    
    // Verificar si la clase usa el namespace
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        // No es una clase del namespace, salir
        return;
    }
    
    // Obtener el nombre relativo de la clase
    $relativeClass = substr($class, $len);
    
    // Reemplazar el separador de namespace con el separador de directorios
    // y agregar .php al final
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';
    
    // Si el archivo existe, cargarlo
    if (file_exists($file)) {
        require $file;
    }
});
