# Registro de Cambios - Frakmenta

---

## v3.1.0 - 28 de noviembre de 2025

### Compatibilidad: PrestaShop 1.7.1.0 - 9.0.0 | PHP 7.4 - 8.4

### Cambios Implementados

#### 1. Optimización de Logs

**Archivo:** `controllers/front/payment.php`

**Cambios:**
- Logs informativos (nivel 1) solo se ejecutan en modo depuración (`_PS_MODE_DEV_`)
- Logs de advertencia (nivel 2) siempre activos
- Logs de transacciones críticos (nivel 4) siempre activos:
  - Operación exitosa (creación de transacción)
  - Operación fallida
- Logs de excepciones (nivel 3) siempre activos

---

#### 2. Eliminación de Hooks Deprecados para PrestaShop 1.9

**Archivo:** `frakmenta.php`

**Cambios:**
- Eliminado hook `payment` (obsoleto desde PS 1.7)
- Eliminado hook `header` (duplicado de `displayHeader`)
- Eliminado hook `displayPaymentTop` (eliminado en PS 1.7.7+)
- Renombrado `backOfficeHeader` → `actionAdminControllerSetMedia`

**Métodos eliminados:**
- `hookPayment()` 
- `hookHeader()` 

---

#### 3. Modernización de Registro de Assets

**Archivo:** `frakmenta.php`

- API moderna de PrestaShop 1.7+
- Mejor control de prioridad y posición
- Eliminada lógica legacy para PS < 1.5

---

#### 4. Reemplazo de Constantes Deprecadas

**Archivo:** `frakmenta.php`

**Cambios realizados:**

##### `__PS_BASE_URI__` → `Context::getContext()->shop->getBaseURI()`

**Ubicaciones actualizadas:**
- `hookPaymentOptions()`
- `requestFrakmentaOperation()`

**Nueva composición para URLs:**
```php
$baseUri = Context::getContext()->shop->getBaseURI();
$resources[] = $base.$baseUri.'modules/' . $this->name . '/views/js/frakmenta_front_operation.js';
$ko_url = _PS_BASE_URL_.Context::getContext()->shop->getBaseURI().'index.php?controller=order&step=3&fk=KO';
```

---
#### 7. Actualización de Versión y Compatibilidad

**Archivo:** `frakmenta.php`

**Cambios:**
```php
// Versión
$this->version = '3.1.1';

// Compatibilidad
$this->ps_versions_compliancy = array('min' => '1.7.1.0', 'max' => '9.1.0');
```

### Hooks Activos (v3.1.0)

#### Registrados y Funcionales:
1. `paymentReturn` - Confirmación de pago
2. `displayHeader` - Assets frontend (CSS/JS)
3. `actionAdminControllerSetMedia` - Assets backoffice (modernizado)
4. `displayPDFInvoice` - Información en facturas PDF
5. `PDFInvoice` - Generación de PDFs
6. `displayTop` - Zona superior de páginas
7. `validate` - Validación de pedidos
8. `displayAdminOrderTop` - Zona superior de pedidos admin
9. `actionFrontControllerSetMedia` - Registro de assets (moderno)
10. `displayAmpFooter` - Compatibilidad AMP
11. `paymentOptions` - Opciones de pago (PS 1.7+)
12. `displayOrderConfirmation` - Confirmación de pedido

#### Hooks Eliminados:
- `payment` (PS 1.6, obsoleto)
- `header` (duplicado de displayHeader)
- `backOfficeHeader` (renombrado a actionAdminControllerSetMedia)
- `displayPaymentTop` (eliminado en PS 1.7.7+)

---

#### Estructura SOLID para el plugin:

```
src/
├── Config/
│   └── FrakmentaConstants.php           # Constantes centralizadas
├── Exception/
│   ├── FrakmentaException.php           # Excepción base
│   └── FrakmentaApiException.php        # Excepciones de API
├── Service/
│   ├── FrakmentaApiClient.php           # Cliente HTTP para API
│   ├── FrakmentaAssetService.php        # Gestión de assets CSS/JS
│   ├── FrakmentaConfigService.php       # Configuración centralizada
│   └── FrakmentaTransactionService.php  # Lógica de transacciones
└── Repository/
    └── FrakmentaTransactionRepository.php # Acceso seguro a BD
```

### 2. Compatibilidad PHP 8.4

#### Eliminados:
- `utf8_encode()` → Sustituido por `mb_convert_encoding()`
- `Tools::displayFileAsDeprecated()` → Eliminado completamente
- Acceso directo a `$_SERVER`, `$_GET`, `$_POST` → Sustituido por `Tools::getValue()`

#### Añadido:
- Inicialización correcta de propiedades de clase
- Validación de extensiones PHP (curl, json, mbstring)

### 3. Seguridad

#### Nuevo formato de Consultas SQL:
```php
$repository->create([
    'id_cart' => (int) $id_cart,
    'id_custom_client' => pSQL($id_custom_client),
    ...
]);
```

#### Acceso a Variables:
```php
Tools::getValue('key')
Tools::getHttpHost()
```

### 4. Eliminación de Código Duplicado
**Servicio centralizado:**
- `FrakmentaAssetService->registerFrakmentaAssets()`

#### Conexiones API:

`FrakmentaApiClient` con métodos específicos:
- `post()`, `get()`
- `getMerchantLimits()`
- `getOperationStatus()`
- `createOperation()`

#### Uso de Constantes:
```php
FrakmentaConstants::MODULE_NAME
FrakmentaConstants::PRODUCTION_URL
FrakmentaConstants::STATE_INITIALIZED
FrakmentaConstants::STATE_OK
```
### 5. Documentación PHPDoc

Todos los métodos y clases ahora incluyen documentación completa

### 6. Manejo de Errores

Se incluyeron manejo de excepciones en todas las llamadas para un mayor control.

```php
try {
    $response = $transactionService->createOperation($cart, $customer);
    $this->ajaxRender($response['data']['token_url']);
} catch (FrakmentaApiException $e) {
    $this->logError($e);
    $this->ajaxRender(json_encode([
        'error' => $e->getMessage(),
        'status' => 'error'
    ]));
}
```

## Notas Importantes

### Compatibilidad:
- PHP 8.4 compatible
- PHP 7.4+ compatible (type hints opcionales)
- PrestaShop 1.7.1.0+